import { useI18n } from "@/lib/i18n";
import logoImg from "@assets/WhatsApp_Image_2025-12-21_at_1.54.00_PM_1766309101495.jpeg";
import dattaMoreImg from "@assets/datu_more_1766311171725.jpeg";
import { Instagram, Facebook, Twitter, Phone, Mail } from "lucide-react";

export function Footer() {
  const { t } = useI18n();
  
  return (
    <footer className="bg-white border-t border-border mt-auto">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-12">
          
          {/* Brand Info */}
          <div className="space-y-4">
            <div className="flex items-center gap-3">
              <img src={logoImg} alt="Daily Bowl" className="h-10 w-10 rounded-full" />
              <span className="font-display font-bold text-xl text-primary">Daily Bowl</span>
            </div>
            <p className="text-muted-foreground max-w-sm">
              Fresh, healthy salads delivered to your doorstep. Promoting a healthy lifestyle with authentic taste.
            </p>
            <div className="flex space-x-4 pt-2">
              <a href="#" className="text-muted-foreground hover:text-accent transition-colors"><Instagram className="w-5 h-5" /></a>
              <a href="#" className="text-muted-foreground hover:text-accent transition-colors"><Facebook className="w-5 h-5" /></a>
              <a href="#" className="text-muted-foreground hover:text-accent transition-colors"><Twitter className="w-5 h-5" /></a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="font-display font-bold text-lg mb-4 text-foreground">{t("nav.contact")}</h3>
            <ul className="space-y-3">
              <li className="flex items-center gap-3 text-muted-foreground">
                <Phone className="w-4 h-4 text-primary" />
                <span>+91 9594620104</span>
              </li>
              <li className="flex items-center gap-3 text-muted-foreground">
                <Mail className="w-4 h-4 text-primary" />
                <span>dailybowls03@gmail.com</span>
              </li>
              <li className="text-sm text-muted-foreground mt-4">
                Designed for health, crafted for taste.
              </li>
            </ul>
          </div>

          {/* Brand Ambassador Small Mention */}
          <div className="bg-secondary/20 p-6 rounded-2xl border border-secondary/50">
            <p className="text-xs font-bold text-accent uppercase tracking-wider mb-3">{t("brand.endorsement")}</p>
            <div className="w-16 h-16 rounded-full overflow-hidden mb-3 border-2 border-primary">
              <img src={dattaMoreImg} alt="Datta More" className="w-full h-full object-cover" />
            </div>
            <p className="font-display font-bold text-lg text-primary">Datta More</p>
          </div>
        </div>

        <div className="border-t border-border mt-12 pt-8 text-center text-sm text-muted-foreground">
          © {new Date().getFullYear()} Daily Bowl. All rights reserved.
        </div>
      </div>
    </footer>
  );
}
