import { cn } from "@/lib/utils";

interface NutritionBadgeProps {
  label: string;
  value: string | number;
  color?: "blue" | "green" | "orange";
}

export function NutritionBadge({ label, value, color = "green" }: NutritionBadgeProps) {
  const colorStyles = {
    blue: "bg-blue-50 text-blue-700 border-blue-100",
    green: "bg-green-50 text-green-700 border-green-100",
    orange: "bg-orange-50 text-orange-700 border-orange-100",
  };

  return (
    <div className={cn(
      "flex flex-col items-center justify-center p-3 rounded-xl border text-center transition-transform hover:scale-105", 
      colorStyles[color]
    )}>
      <span className="text-sm font-bold">{value}</span>
      <span className="text-[10px] uppercase tracking-wide opacity-70">{label}</span>
    </div>
  );
}
