# Daily Bowl - Healthy Salad Delivery Application

## Overview

Daily Bowl is a full-stack web application for a healthy salad delivery service targeting the Indian market (with English and Marathi language support). The platform allows customers to browse salads, view nutritional information, subscribe to meal plans, explore combo deals, and submit contact/franchise inquiries. The application features a fresh, health-focused design with green and orange accent colors.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
- **Framework**: React 18 with TypeScript
- **Routing**: Wouter (lightweight React router)
- **State Management**: TanStack React Query for server state caching and synchronization
- **Styling**: Tailwind CSS with CSS custom properties for theming
- **UI Components**: shadcn/ui component library (Radix UI primitives with custom styling)
- **Animations**: Framer Motion for page transitions and micro-interactions
- **Form Handling**: React Hook Form with Zod validation
- **Build Tool**: Vite for fast development and optimized production builds

### Backend Architecture
- **Runtime**: Node.js with Express.js
- **Language**: TypeScript (ESM modules)
- **API Design**: RESTful JSON API with routes defined in shared schema
- **Validation**: Zod schemas for request/response validation
- **Development**: Vite dev server with HMR proxied through Express

### Data Layer
- **ORM**: Drizzle ORM for type-safe database operations
- **Database**: PostgreSQL (connection via DATABASE_URL environment variable)
- **Schema Definition**: Shared schema in `shared/schema.ts` using Drizzle's pgTable definitions
- **Migrations**: Drizzle Kit for schema migrations (`db:push` command)

### Project Structure
```
├── client/              # React frontend application
│   ├── src/
│   │   ├── components/  # UI components (layout, ui from shadcn)
│   │   ├── hooks/       # Custom React hooks for data fetching
│   │   ├── lib/         # Utilities (i18n, queryClient)
│   │   └── pages/       # Route page components
├── server/              # Express backend
│   ├── db.ts           # Database connection
│   ├── routes.ts       # API route handlers
│   ├── storage.ts      # Data access layer
│   └── index.ts        # Server entry point
├── shared/              # Shared code between client/server
│   ├── schema.ts       # Drizzle database schema & Zod types
│   └── routes.ts       # API route definitions with type schemas
```

### Key Design Patterns
- **Shared Types**: Database schema and API contracts defined once in `shared/` and consumed by both frontend and backend
- **Storage Abstraction**: `IStorage` interface in `server/storage.ts` allows swapping implementations
- **Internationalization**: React Context-based i18n system supporting English and Marathi translations
- **Component Library**: shadcn/ui provides accessible, customizable components with consistent styling

### Build & Deployment
- **Development**: `npm run dev` runs Vite dev server with Express backend
- **Production Build**: `npm run build` creates optimized client bundle and bundles server with esbuild
- **Static Serving**: Production server serves built client files from `dist/public`

## External Dependencies

### Database
- **PostgreSQL**: Primary data store, connected via `DATABASE_URL` environment variable
- **connect-pg-simple**: Session storage (available but not currently active)

### Frontend Libraries
- **@tanstack/react-query**: Server state management
- **framer-motion**: Animation library
- **lucide-react**: Icon library
- **react-hook-form**: Form state management
- **zod**: Schema validation

### Development Tools
- **Vite**: Build tool with React plugin
- **Drizzle Kit**: Database migration tooling
- **TypeScript**: Type checking across full stack

### Fonts & Assets
- **Google Fonts**: DM Sans (body) and Outfit (display) fonts loaded via CDN
- **Static Assets**: Logo and brand ambassador images stored in `attached_assets/`