import { pgTable, text, serial, integer, boolean } from "drizzle-orm/pg-core";
import { createInsertSchema } from "drizzle-zod";
import { z } from "zod";

export const outlets = pgTable("outlets", {
  id: serial("id").primaryKey(),
  name: text("name").notNull(),
  marathiName: text("marathi_name"),
  address: text("address").notNull(),
  marathiAddress: text("marathi_address"),
  lat: text("lat").notNull(),
  lng: text("lng").notNull(),
  phone: text("phone").notNull(),
});

export const insertOutletSchema = createInsertSchema(outlets).omit({ id: true });
export type Outlet = typeof outlets.$inferSelect;
export type InsertOutlet = z.infer<typeof insertOutletSchema>;

export const salads = pgTable("salads", {
  id: serial("id").primaryKey(),
  name: text("name").notNull(),
  marathiName: text("marathi_name"),
  description: text("description").notNull(),
  marathiDescription: text("marathi_description"),
  price: integer("price").notNull(),
  ingredients: text("ingredients").array().notNull(),
  calories: integer("calories").notNull(),
  protein: text("protein").notNull(),
  carbs: text("carbs").notNull(),
  fat: text("fat").notNull(),
  isVeg: boolean("is_veg").default(true),
  imageUrl: text("image_url").notNull(),
  category: text("category").notNull(),
});

export const subscriptions = pgTable("subscriptions", {
  id: serial("id").primaryKey(),
  name: text("name").notNull(),
  marathiName: text("marathi_name"),
  description: text("description").notNull(),
  marathiDescription: text("marathi_description"),
  type: text("type").notNull(), // "weekly" or "monthly"
  duration: integer("duration").notNull(), // number of weeks/months
  basePrice: integer("base_price").notNull(),
  discountedPrice: integer("discounted_price").notNull(),
  savingsPercentage: integer("savings_percentage").notNull(),
  saladsPerWeek: integer("salads_per_week").notNull(),
  imageUrl: text("image_url").notNull(),
});

export const combos = pgTable("combos", {
  id: serial("id").primaryKey(),
  name: text("name").notNull(),
  marathiName: text("marathi_name"),
  description: text("description").notNull(),
  marathiDescription: text("marathi_description"),
  saladIds: text("salad_ids").array().notNull(), // array of salad IDs
  basePrice: integer("base_price").notNull(),
  comboPrice: integer("combo_price").notNull(),
  discount: integer("discount").notNull(), // discount percentage
  imageUrl: text("image_url").notNull(),
  servings: integer("servings").notNull(), // number of salads in combo
});

export const contactRequests = pgTable("contact_requests", {
  id: serial("id").primaryKey(),
  name: text("name").notNull(),
  phone: text("phone").notNull(),
  message: text("message").notNull(),
});

export const insertSaladSchema = createInsertSchema(salads).omit({ id: true });
export const insertSubscriptionSchema = createInsertSchema(subscriptions).omit({ id: true });
export const insertComboSchema = createInsertSchema(combos).omit({ id: true });
export const insertContactRequestSchema = createInsertSchema(contactRequests).omit({ id: true });

export type Salad = typeof salads.$inferSelect;
export type InsertSalad = z.infer<typeof insertSaladSchema>;
export type Subscription = typeof subscriptions.$inferSelect;
export type InsertSubscription = z.infer<typeof insertSubscriptionSchema>;
export type Combo = typeof combos.$inferSelect;
export type InsertCombo = z.infer<typeof insertComboSchema>;
export type ContactRequest = typeof contactRequests.$inferSelect;
export type InsertContactRequest = z.infer<typeof insertContactRequestSchema>;
